*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Phorate oxon sulfoxide                               *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";
libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data ethoprophos;
     set epa.ethoprop;
run;
proc sort data=ethoprophos;
     by id;
run;

/*
ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfoxide - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Phorateoxonsulfoxide);
ods rtf close;
*/

*==> Human vs. rat;

title2 "final model 3: a model with different random effects between species - different order of magnitute for rhb and rrb";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=ethoprophos itdetails tech=nrridg lis=3;
      PARMS ha=0.3		hb=0.2
			ra=0.7		rb=0.9
			gh1=0.4 gh12=0.2 gh2=0.4
			gr1=0.3 gr12=0.7 gr2=0.1
			S2E=0.2;
			gha=gh1*gh1/100;
			ghab=gh1*gh12/100;
			ghb=gh12*gh12/100+gh2*gh2/100;
			gra=gr1*gr1;
			grab=gr1*gr12;
			grb=gr12*gr12+gr2*gr2;
            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-3 + H_I__M + rrb*Rat*1e-3 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
	  RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha, 
												 		 ghab, ghb,
														 0,    	  0,   gra,
														 0,       0,   grab, grb]) SUBJECT=ID out=RandID_HR; 

	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1/100;
	  estimate "ghab" gh1*gh12/100;
	  estimate "ghb" gh12*gh12/100+gh2*gh2/100;
  	  estimate "gra" gr1*gr1;
	  estimate "grab" gr1*gr12;
	  estimate "grb" gr12*gr12+gr2*gr2;

	  id pred2;
  	  predict pred2 out=Resid_HR;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\ethoprophos human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=ethoprophos, model=3)
ods rtf close;
*%Calculate_Ki(chemical=PhorateOxonSulfoxide, Hadj=1e-5, Radj=1e-5);

*==> Adult vs. Infant;


title "CEB final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=ethoprophos(where=(Human=1)) tech=nrridg lis=3 method=firo;
      PARMS ada=0.31	adB=0.21
			ia=.32 iB=0.18
			gh1=0.1 to 1 by 0.1 gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=0.173 / best=50;
			gha=gh1*gh1*100;
			ghab=gh1*gh12*10;
			ghb=gh12*gh12+gh2*gh2*100;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  estimate "gha" gh1*gh1*100;
	  estimate "ghab" gh1*gh12*10;
	  estimate "ghb" gh12*gh12+gh2*gh2*100;
	  id pred2;
      predict pred2 out=Resid_AI;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\ethoprophos Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=ethoprophos, model=2);
ods rtf close;

/*
*===> Exponent's model;
title "Exponent's final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=phorateoxonsulfoxide(where=(Human=1)) itdetails tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=1.0288	adB=0.2037
			ia=.882 iB=0.1748
			gha=2.9991 	ghab=0.6904	ghb=0.1650
			S2E=0.09673;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-4*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\PhorateOxonSulfoxide Adult-Infant (Exponent's model).rtf" startpage=no;
%DiagnosticsAI(chemical=PhorateOxonSulfoxide, model=2);
ods rtf close;
*/

*===> Male vs. Female;



title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=ethoprophos(where=(Human=1)) method=firo /* itdetails */ tech=newrap lis=3 maxiter=100000;
      PARMS ma=.30 mb= 0.20
			fa=0.32 fB=0.21
			gh1=0.1 to 1 by 0.1 gh12=0.1 to 1 by 0.1 gh2=0.1 to 1 by 0.1
			S2E=.17  / best=50;
			gha=gh1*gh1*100;
			ghab=gh1*gh12*100;
			ghb=gh12*gh12*100+gh2*gh2*100;
			rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-3 + H_I__M*male + rfb*female*1e-3 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF;  
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  estimate "gha" gh1*gh1*100;
	  estimate "ghab" gh1*gh12*100;
	  estimate "ghb" gh12*gh12*100+gh2*gh2*100;
	  id pred2;
		predict pred2 out=Resid_MF;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\ethoprophos Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=ethoprophos, model=2);
ods rtf close;


*===> Caucasian vs. Other Races;


/* Try to fit model 2 instead */

/*
title "Final model 3 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=ethoprophos(where=(Human=1)) method=firo itdetails tech=newrap lis=3 maxiter=100000;
      PARMS ca=.31	cB=.21
			ora=.31 orB=0.20
			gc1=0.4 gc12=0.1 gc2=0.5
			gor1=0.1 to 1 by 0.1 gor12=0.1 to 1 by 0.1  
			S2E=.17 / best= 50;
			gca=gc1*gc1/100;
			gcab=gc1*gc12/100;
			gcb=gc12*gc12/100+gc2*gc2/100;
			gora=gor1*gor1/100;
			gorab=gor1*gor12/100;
			gorb=gor12*gor12/100; 
            rca=ca+uca;
			rora=ora+uora;
            rcb=cB+ucb;
			rorb=orB+uorb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-3 + H_I__M*caucasian + rorb*otherrace*1e-3 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
   RANDOM  uca ucb uora uorb ~ normal([0, 0, 0, 0],   [gca, 
														gcab, gcb, 
														0,    0,     gora, 
														0,    0,     gorab,   gorb]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  estimate "gca" gc1*gc1/100;
	  estimate "gcab" gc1*gc12/100;
	  estimate "gcb" gc12*gc12/100+gc2*gc2/100;
  	  estimate "gora" gor1*gor1/100;
	  estimate "gorab" gor1*gor12/100;
	  estimate "gorb" gor12*gor12/100 ;

	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\ethoprophos Caucasian-Other Races.r1.rtf" startpage=no;
%DiagnosticsCO(chemical=ethoprophos, model=3);
ods rtf close;

*/

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=ethoprophos(where=(Human=1)) method=firo itdetails tech=newrap lis=3 maxiter=100000;
      PARMS ca=.31	cB=.21
			ora=.31 orB=0.20
			gc1=0.1 to 1 by 0.1 gc12=0.1 to 1 by 0.1 gc2=0.1 to 1 by 0.1 
			S2E=.17 / best= 50;
			gca=gc1*gc1/100;
			gcab=gc1*gc12/100;
			gcb=gc12*gc12/100+gc2*gc2/100;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-3 + H_I__M*caucasian + rorb*otherrace*1e-3 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
   RANDOM  uha uhb ~ normal([0, 0],   [gca, 
														gcab, gcb]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  estimate "gca" gc1*gc1/100;
	  estimate "gcab" gc1*gc12/100;
	  estimate "gcb" gc12*gc12/100+gc2*gc2/100;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\ethoprophos Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=ethoprophos, model=2);
ods rtf close;

%resids